/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:37:42 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.NoSuchElementException;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.plot.CodonUsageWeight;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class CodonUsageWeight_ESTest extends CodonUsageWeight_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      SymbolList symbolList0 = SymbolList.EMPTY_LIST;
      assertNotNull(symbolList0);
      
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(symbolList0);
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      
      CodonUsageWeight codonUsageWeight0 = null;
      try {
        codonUsageWeight0 = new CodonUsageWeight((File) null, strand0);
        fail("Expecting exception: NoSuchElementException");
      
      } catch(NoSuchElementException e) {
         //
         // There is no parser for the empty alphabet. Attempted to retrieve token
         //
         verifyException("org.biojava.bio.symbol.EmptyAlphabet", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(0, 0, 0, 0, 0).when(strand0).getACount();
      doReturn(0, 0, 0, 0, 0).when(strand0).getCCount();
      doReturn(0, 0, 0, 0, 0).when(strand0).getGCount();
      doReturn(0, 0, 0, 0, 0).when(strand0).getSequenceLength();
      doReturn(0, 0, 0, 0, 0).when(strand0).getTCount();
      CodonUsageWeight codonUsageWeight0 = null;
      try {
        codonUsageWeight0 = new CodonUsageWeight((File) null, strand0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      File file0 = mock(File.class, new ViolatedAssumptionAnswer());
      doReturn("2^xo,RS|#R$`h*vw").when(file0).getAbsolutePath();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((-67), 2, 1, 1459, 1459).when(strand0).getACount();
      doReturn(1459, 2, 1459, 571, (-67)).when(strand0).getCCount();
      doReturn((-1450), (-1450), 29, 571, 2).when(strand0).getGCount();
      doReturn(1, (-1450), 1, 1, (-1450)).when(strand0).getSequenceLength();
      doReturn((-1450), 571, 29, 34, 56).when(strand0).getTCount();
      CodonUsageWeight codonUsageWeight0 = null;
      try {
        codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      File file0 = MockFile.createTempFile("MQz!AiC7xY]:,VAg?", "MQz!AiC7xY]:,VAg?");
      assertNotNull(file0);
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canExecute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/MQz!AiC7xY]:,VAg?0MQz!AiC7xY]:,VAg?", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("MQz!AiC7xY]:,VAg?0MQz!AiC7xY]:,VAg?", file0.getName());
      assertTrue(file0.isAbsolute());
      
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("MQz!AiC7xY]:,VAg?");
      assertNotNull(genbankStreamSequence0);
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(16, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(bases0);
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(16, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(16, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(codonUsageWeight0);
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.getUsableSpace());
      assertFalse(file0.isHidden());
      assertTrue(file0.canExecute());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/MQz!AiC7xY]:,VAg?0MQz!AiC7xY]:,VAg?", file0.toString());
      assertTrue(file0.isFile());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals(0L, file0.length());
      assertEquals(0L, file0.getFreeSpace());
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T", file0.getParent());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals("MQz!AiC7xY]:,VAg?0MQz!AiC7xY]:,VAg?", file0.getName());
      assertTrue(file0.isAbsolute());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(16, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(17, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("MQz!AiC7xY]:,VAg?0MQz!AiC7xY]:,VAg?", codonUsageWeight0.getName());
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      File file0 = MockFile.createTempFile("6]/UV=Y", "6]/UV=Y");
      assertNotNull(file0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertEquals("UV=Y", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(1637, 1637, 2, 2, 2).when(strand0).getACount();
      doReturn(1637, 2, 1183, 57, 121).when(strand0).getCCount();
      doReturn(2, 2, 1183, 57, 168).when(strand0).getGCount();
      doReturn(1637, 1183, 1183, 3, 2).when(strand0).getSequenceLength();
      doReturn(168, 1637, 3, 4, 4).when(strand0).getTCount();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertEquals("UV=Y", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      assertEquals("UV=Y", codonUsageWeight0.getName());
      
      float float0 = codonUsageWeight0.getCodonValue('a', 'U', 't');
      assertEquals(1.0F, float0, 0.01F);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canWrite());
      assertTrue(file0.isFile());
      assertEquals("UV=Y", file0.getName());
      assertTrue(file0.canRead());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.length());
      assertTrue(file0.exists());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      assertEquals("UV=Y", codonUsageWeight0.getName());
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      File file0 = MockFile.createTempFile("6]/UV=Y", "6]/UV=Y");
      assertNotNull(file0);
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals("UV=Y", file0.getName());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(1637, 1637, 2, 2, 2).when(strand0).getACount();
      doReturn(1637, 2, 1183, 57, 121).when(strand0).getCCount();
      doReturn(2, 2, 1183, 57, 168).when(strand0).getGCount();
      doReturn(1637, 1183, 1183, 3, 2).when(strand0).getSequenceLength();
      doReturn(168, 1637, 3, 4, 4).when(strand0).getTCount();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals("UV=Y", file0.getName());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("UV=Y", codonUsageWeight0.getName());
      
      float float0 = codonUsageWeight0.getCodonValue('s', 'l', 'a');
      assertEquals(1.0F, float0, 0.01F);
      assertFalse(file0.isDirectory());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      assertEquals(0L, file0.length());
      assertEquals("UV=Y", file0.getName());
      assertEquals(0L, file0.getFreeSpace());
      assertTrue(file0.canWrite());
      assertTrue(file0.isAbsolute());
      assertTrue(file0.isFile());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canExecute());
      assertEquals(0L, file0.getTotalSpace());
      assertEquals(1392409281320L, file0.lastModified());
      assertTrue(file0.canRead());
      assertTrue(file0.exists());
      assertEquals("UV=Y", codonUsageWeight0.getName());
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      File file0 = MockFile.createTempFile("6]/UV=Y", "6]/UV=Y");
      assertNotNull(file0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("UV=Y", file0.getName());
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(1637, 1637, 2, 2, 2).when(strand0).getACount();
      doReturn(1637, 2, 1183, 57, 121).when(strand0).getCCount();
      doReturn(2, 2, 1183, 57, 168).when(strand0).getGCount();
      doReturn(1637, 1183, 1183, 3, 2).when(strand0).getSequenceLength();
      doReturn(168, 1637, 3, 4, 4).when(strand0).getTCount();
      CodonUsageWeight codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
      assertNotNull(codonUsageWeight0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("UV=Y", file0.getName());
      assertEquals("UV=Y", codonUsageWeight0.getName());
      
      String string0 = codonUsageWeight0.getName();
      assertEquals("UV=Y", string0);
      assertNotNull(string0);
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]/UV=Y", file0.toString());
      assertEquals(1392409281320L, file0.lastModified());
      assertEquals(0L, file0.getTotalSpace());
      assertTrue(file0.exists());
      assertTrue(file0.isFile());
      assertEquals("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/6]/UV=Y06]", file0.getParent());
      assertTrue(file0.canExecute());
      assertTrue(file0.canRead());
      assertTrue(file0.isAbsolute());
      assertFalse(file0.isHidden());
      assertEquals(0L, file0.getUsableSpace());
      assertTrue(file0.canWrite());
      assertEquals(0L, file0.length());
      assertFalse(file0.isDirectory());
      assertEquals(0L, file0.getFreeSpace());
      assertEquals("UV=Y", file0.getName());
      assertEquals("UV=Y", codonUsageWeight0.getName());
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      File file0 = mock(File.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(file0).getAbsolutePath();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(0, 1907, 0, (-749), 2).when(strand0).getACount();
      doReturn(2, 4, 3, 790, 4573).when(strand0).getCCount();
      doReturn(2, 4573, 790, (-2727), (-749)).when(strand0).getGCount();
      doReturn(8930, 64, (-749), 4573, (-669)).when(strand0).getSequenceLength();
      doReturn(790, 1, 4, 8771, 2).when(strand0).getTCount();
      CodonUsageWeight codonUsageWeight0 = null;
      try {
        codonUsageWeight0 = new CodonUsageWeight(file0, strand0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }
}
