#------------------
# CamiTK packaging
#------------------

# Do not forget to change the version variables in CamiTKInternalBuild.cmake
#
# To make a source tar ball, just use the custom target camitk_package_source, e.g. "make camitk_package_source"
#
# To make an installer, use the custom target camitk_package, e.g "make camitk_package"
#
# To build source package
# make camitk_package_source
# (it generates the correct CamiTKVersion.h)
#
# To check the content of a deb package:
# dpkg --contents package.deb
# To install the content of a deb in a subdirectory instead of system-wide:
# dpkg --vextract package.deb subdirectory
#
# To produce a window installer with NSIS from linux, you need to install the nsis package (on ubuntu, type "sudo apt-get install nsis")
# Be sure to use the makensisw.exe and not makensis.exe as the value of the MAKENSIS variable.
#
# To generate different components that can be opt out at install time, see
# http://www.itk.org/Wiki/CMake:Component_Install_With_CPack
#
# More generally see http://www.itk.org/Wiki/CMake:CPackConfiguration

macro(camitk_opensource_packaging)
 
# package name
string(TOLOWER ${CAMITK_PROJECT_NAME} CPACK_PACKAGE_NAME)
set(CPACK_PACKAGE_VERSION_MAJOR ${CAMITK_VERSION_MAJOR})
set(CPACK_PACKAGE_VERSION_MINOR ${CAMITK_VERSION_MINOR})
set(CPACK_PACKAGE_VERSION_PATCH ${CAMITK_VERSION_PATCH})
string(TOLOWER "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${CAMITK_VER_NICKNAME}-${LSB_DISTRIB}_${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_FILE_NAME)

# contact information
set(CPACK_PACKAGE_VENDOR "UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525")
set(CPACK_PACKAGE_CONTACT "http://camitk.imag.fr")
set(CPACK_DEBIAN_PACKAGE_MAINTAINER "CamiTK Developers <camitk-developers@lists.forge.imag.fr>")

# resource files
set(CPACK_RESOURCE_FILE_README "${CMAKE_CURRENT_SOURCE_DIR}/README")
set(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/COPYRIGHT")

# executable
set(CPACK_PACKAGE_EXECUTABLES "camitk-imp" "camitk-imp" "camitk-actionstatemachine" "camitk-actionstatemachine")

# CamiTK package description
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "CamiTK stands for Computer Assisted Medical Intervention Tool Kit and aims at providing an easy way to protype medical applications. CamiTK functionnalities are extendable thanks to plugins. This package includes the IMP application with main plugins that allow users to interact with medical images (2D, 3D), process them and simulate biomechanichal deformations. It also includes the actionstatemachine application that allows user to easily run a pipelines of algorithms on images.")

# Files to ignore during generation of the package
set(CPACK_SOURCE_IGNORE_FILES
"~$"
"/CVS/"
"tags"
"/\\\\.svn/"
"/\\\\.git/"
"/kdev4$/"
"/build/"
"\\\\.kdevses$"
"\\\\.kdev4$"
"\\\\.tmp$"
"\\\\.tmp.save$"
"\\\\.kdevelop\\\\.pcs$"
".DS_Store"
${CPACK_SOURCE_IGNORE_FILES}
)

set(CPACK_SOURCE_GENERATOR "TGZ" "ZIP" )




# ----------------------------------
# Unix packages (Ubuntu and Debian)
# ----------------------------------
if (UNIX AND NOT WIN32)
   
   message(STATUS "Packaging CamiTK for UNIX systems")
   # Try to find architecture
   execute_process(COMMAND uname -m OUTPUT_VARIABLE CPACK_PACKAGE_ARCHITECTURE)
   string(STRIP "${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_ARCHITECTURE)
   # Try to find distro name and distro-specific arch
   execute_process(COMMAND lsb_release -is OUTPUT_VARIABLE LSB_ID)
   execute_process(COMMAND lsb_release -rs OUTPUT_VARIABLE LSB_RELEASE)
   string(STRIP "${LSB_ID}" LSB_ID)
   string(STRIP "${LSB_RELEASE}" LSB_RELEASE)
   set(LSB_DISTRIB "${LSB_ID}${LSB_RELEASE}")
   if(NOT LSB_DISTRIB)
      set(LSB_DISTRIB "unix")
   endif(NOT LSB_DISTRIB)
   message(STATUS "Packager architecture : ${LSB_DISTRIB}")

   #Find DPKG
   find_program(DPKG
      NAMES dpkg-deb
      PATHS "/usr/bin" #Add paths here
   )
   if ( DPKG )
      get_filename_component(DPKG_PATH ${DPKG} ABSOLUTE)
      message(STATUS "Packaging deb using ${DPKG_PATH}: OK")
      set(DPKG_FOUND "YES")
   else() 
      set(DPKG_FOUND "NO")
   endif()
   
   # Packaging requires ITK
   find_package(ITK REQUIRED)
   include(${ITK_USE_FILE})
   
    # For Debian-based distribs we want to create DEB packages.
    if("${LSB_DISTRIB}" MATCHES "Ubuntu|Debian")

        # We need to alter the architecture names as per distro rules
        if("${CPACK_PACKAGE_ARCHITECTURE}" MATCHES "i[3-6]86")
            set(CPACK_PACKAGE_ARCHITECTURE i386)
        endif()
        if("${CPACK_PACKAGE_ARCHITECTURE}" MATCHES "x86_64")
            set(CPACK_PACKAGE_ARCHITECTURE amd64)
        endif()
        # Set the dependencies based on the distrib version

        # Installation path
        # Set the install location to "/usr"
        # PLEASE, set the CamiTK install root path in your CMake command line / GUI (and not directly here)      
        set(CPACK_PACKAGING_INSTALL_PREFIX "/usr")
        set(CPACK_PACKAGE_DEFAULT_LOCATION "/usr")
        set(CPACK_SET_DESTDIR TRUE)

        # Dependencies depending on the Operating System.
        # Ubuntu12.xx 
        # WARNING Beware to the syntax of the Debian package dependencies, else it won't manage to install.
        if("${LSB_DISTRIB}" MATCHES "Ubuntu12.04")
            set(LSB_DISTRIB "Ubuntu12.xx")
            set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev (>= 4:4.8), libqtwebkit4 (>= 2), libqtwebkit-dev (>= 2), libvtk5.8 (>= 5.8.0), libvtk5-dev (>= 5.8.0), libvtk5.8-qt4 (>= 5.8.0), libvtk5-qt4-dev (>= 5.8.0), libinsighttoolkit3-dev (>= 3.20.1),  vtkdata (>= 5.8.0-1), vtk-doc (>= 5.8.0), vtk-examples (>= 5.8.0), tcl-vtk (>= 5.8.0), libinsighttoolkit3.20 (>= 3.20.1), libgdcm2-dev (>= 2), libtiff4-dev (>= 3.9), libopenjpeg-dev (>= 1.3), libxml2 (>= 2.7.8), libxml2-dev (>= 2.7.8), xsdcxx (>= 3.3.0), libxerces-c-dev (>= 3.1.1), libgdcm2.0 (>= 2), libgdcm2-dev (>= 2), libvtkgdcm2.0 (>= 2), libvtkgdcm2-dev (>= 2)")
        endif()
            if("${LSB_DISTRIB}" MATCHES "Ubuntu12.04.1")
            set(LSB_DISTRIB "Ubuntu12.xx")
            set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev (>= 4:4.8), libqtwebkit4 (>= 2), libqtwebkit-dev (>= 2), libvtk5.8 (>= 5.8.0), libvtk5-dev (>= 5.8.0), libvtk5.8-qt4 (>= 5.8.0), libvtk5-qt4-dev (>= 5.8.0), libinsighttoolkit3-dev (>= 3.20.1),  vtkdata (>= 5.8.0-1), vtk-doc (>= 5.8.0), vtk-examples (>= 5.8.0), tcl-vtk (>= 5.8.0), libinsighttoolkit3.20 (>= 3.20.1), libgdcm2-dev (>= 2), libtiff4-dev (>= 3.9), libopenjpeg-dev (>= 1.3), libxml2 (>= 2.7.8), libxml2-dev (>= 2.7.8), xsdcxx (>= 3.3.0), libxerces-c-dev (>= 3.1.1), libgdcm2.0 (>= 2), libgdcm2-dev (>= 2), libvtkgdcm2.0 (>= 2), libvtkgdcm2-dev (>= 2)")
        endif()
            if("${LSB_DISTRIB}" MATCHES "Ubuntu12.10")
            set(LSB_DISTRIB "Ubuntu12.xx")
            set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev (>= 4:4.8), libqtwebkit4 (>= 2), libqtwebkit-dev (>= 2), libvtk5.8 (>= 5.8.0), libvtk5-dev (>= 5.8.0), libvtk5.8-qt4 (>= 5.8.0), libvtk5-qt4-dev (>= 5.8.0), libinsighttoolkit3-dev (>= 3.20.1),  vtkdata (>= 5.8.0-1), vtk-doc (>= 5.8.0), vtk-examples (>= 5.8.0), tcl-vtk (>= 5.8.0), libinsighttoolkit3.20 (>= 3.20.1), libgdcm2-dev (>= 2), libtiff4-dev (>= 3.9), libopenjpeg-dev (>= 1.3), libxml2 (>= 2.7.8), libxml2-dev (>= 2.7.8), xsdcxx (>= 3.3.0), libxerces-c-dev (>= 3.1.1), libgdcm2.0 (>= 2), libgdcm2-dev (>= 2), libvtkgdcm2.0 (>= 2), libvtkgdcm2-dev (>= 2)")
        endif()
        # Debian dependencies
        if ("${LSB_DISTRIB}" MATCHES "Debian7.*") # Debian Wheezy
            set(LSB_DISTRIB "Debian-7.x-Wheezy")
            set(CPACK_DEBIAN_PACKAGE_DEPENDS "libqt4-dev (>= 4:4.8), libqtwebkit4 (>= 2), libqtwebkit-dev (>= 2), libvtk5.8 (>= 5.8.0), libvtk5-dev (>= 5.8.0), libvtk5.8-qt4 (>= 5.8.0), libvtk5-qt4-dev (>= 5.8.0), libinsighttoolkit3-dev (>= 3.20.1),  vtkdata (>= 5.8.0-1), vtk-doc (>= 5.8.0), vtk-examples (>= 5.8.0), tcl-vtk (>= 5.8.0), libinsighttoolkit3.20 (>= 3.20.1), libgdcm2-dev (>= 2.), libtiff4-dev (>= 3.9), libopenjpeg-dev (>= 1.3), libxml2 (>= 2.7.8), libxml2-dev (>= 2.7.8), xsdcxx (>= 3.3.0), libxerces-c-dev (>= 3.1.1), libgdcm2.2 (>= 2), libgdcm2-dev (>= 2), libvtkgdcm2.2 (>= 2), libvtkgdcm2-dev (>= 2)")
        endif()

      if(NOT CPACK_DEBIAN_PACKAGE_DEPENDS)
         message(STATUS "Packaging for ${LSB_DISTRIB} not supported yet.\n")
      endif()

   endif()

   # package name
   string(TOLOWER "${CPACK_PACKAGE_NAME}_${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${LSB_DISTRIB}_${CPACK_PACKAGE_ARCHITECTURE}" CPACK_PACKAGE_FILE_NAME)

endif()



if(WIN32 AND NOT UNIX)
    # -----------------------
    # NSIS Windows installer
    # -----------------------

    # Update package name for windows release
    set(LSB_DISTRIB "win32")
    set(CPACK_PACKAGE_ARCHITECTURE i386)
    string(TOLOWER "${CPACK_PACKAGE_NAME}-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}-${CAMITK_VER_NICKNAME}-${LSB_DISTRIB}" CPACK_PACKAGE_FILE_NAME)

    # Try to find Makensis on Linux distribution
    find_program(MAKENSIS
     NAMES makensis
     PATHS "/usr/bin"
    )

    if(MAKENSIS)

    # MinGW compiler
    if ("${CMAKE_GENERATOR}" MATCHES "MinGW Makefiles")
      
        message(STATUS "Packaging nsis using ${MAKENSIS} with MinGW compiler")

        set(CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS 
        ##TODO use GetPrerequisites.cmake (i.e. find a better way to list dependencies)
        ##get_prerequisites() is not well enough documented to justify the time investement - EP May 2011
        # Qt dependencies
        ${QT_BINARY_DIR}/QtCore4.dll 
        ${QT_BINARY_DIR}/QtGui4.dll
        ${QT_BINARY_DIR}/QtSvg4.dll
        ${QT_BINARY_DIR}/QtXml4.dll
        ${QT_BINARY_DIR}/QtNetwork4.dll
        ${QT_BINARY_DIR}/QtSql4.dll
        ${QT_BINARY_DIR}/QtWebKit4.dll
        # VTK dependencies		
        ${VTK_DIR}/bin/libQVTK.dll 
        ${VTK_DIR}/bin/libvtkCommon.dll 
        ${VTK_DIR}/bin/libvtksys.dll 
        ${VTK_DIR}/bin/libvtkFiltering.dll 
        ${VTK_DIR}/bin/libvtkGraphics.dll 
        ${VTK_DIR}/bin/libvtkHybrid.dll 
        ${VTK_DIR}/bin/libvtkIO.dll 
        ${VTK_DIR}/bin/libvtkImaging.dll
        ${VTK_DIR}/bin/libvtkRendering.dll 
        ${VTK_DIR}/bin/libvtkVolumeRendering.dll
        ${VTK_DIR}/bin/libvtkverdict.dll 
        ${VTK_DIR}/bin/libvtkDICOMParser.dll 
        ${VTK_DIR}/bin/libvtkNetCDF.dll 
        ${VTK_DIR}/bin/libvtkNetCDF_cxx.dll
        ${VTK_DIR}/bin/libvtkexpat.dll 
        ${VTK_DIR}/bin/libvtkjpeg.dll 
        ${VTK_DIR}/bin/libvtkmetaio.dll 
        ${VTK_DIR}/bin/libvtkpng.dll 
        ${VTK_DIR}/bin/libvtktiff.dll 
        ${VTK_DIR}/bin/libvtkzlib.dll 
        ${VTK_DIR}/bin/libvtkInfovis.dll 
        ${VTK_DIR}/bin/libvtkfreetype.dll 
        ${VTK_DIR}/bin/libvtkftgl.dll
        ${VTK_DIR}/bin/libvtkalglib.dll 
        ${VTK_DIR}/bin/libvtklibxml2.dll 
        ${VTK_DIR}/bin/libvtkViews.dll 
        ${VTK_DIR}/bin/libvtkexoIIc.dll
        ${VTK_DIR}/bin/libvtkWidgets.dll
        ${VTK_DIR}/bin/vtkhdf5.dll 
        ${VTK_DIR}/bin/vtkhdf5_hl.dll 
        ${VTK_DIR}/bin/libLSDyna.dll            
        # Xerces-c dependency
        # ${XERCESC_ROOT_DIR}/bin/xerces-c_3_1.dll 
        # Libxml2 dependencies
        # ${LIBXML2_INCLUDE_DIR}/../bin/iconv.dll
        C:/dev/libxml2/2.8/bin/libxml2-2.dll
        # ${LIBXML2_INCLUDE_DIR}/../bin/zlib1.dll
        # ITK dependency 
        ${ITK_DIR}/../../bin/libITKCommon.dll
        ${ITK_DIR}/../../bin/libITKBasicFilters.dll
        ${ITK_DIR}/../../lib/InsightToolkit/libitksys.dll
        ${ITK_DIR}/../../bin/libitkvnl.dll
        ${ITK_DIR}/../../bin/libitkvnl_algo.dll
        ${ITK_DIR}/../../bin/libITKIO.dll
        ${ITK_DIR}/../../bin/libitkv3p_lsqr.dll
        ${ITK_DIR}/../../bin/libitkv3p_netlib.dll
        ${ITK_DIR}/../../bin/libITKDICOMParser.dll
        ${ITK_DIR}/../../bin/libITKEXPAT.dll
        ${ITK_DIR}/../../bin/libitkgdcm.dll
        ${ITK_DIR}/../../bin/libitkjpeg8.dll
        ${ITK_DIR}/../../bin/libITKMetaIO.dll
        ${ITK_DIR}/../../bin/libITKniftiio.dll
        ${ITK_DIR}/../../bin/libITKNrrdIO.dll
        ${ITK_DIR}/../../bin/libitkpng.dll
        ${ITK_DIR}/../../bin/libitktiff.dll
        ${ITK_DIR}/../../bin/libitkzlib.dll
        ${ITK_DIR}/../../bin/libitkjpeg12.dll
        ${ITK_DIR}/../../bin/libitkjpeg16.dll
        ${ITK_DIR}/../../bin/libitkopenjpeg.dll
        ${ITK_DIR}/../../bin/libITKznz.dll
        # MinGW Dependencies
        C:/dev/MinGW/bin/libgcc_s_dw2-1.dll
        C:/dev/MinGW/bin/libstdc++-6.dll
        C:/dev/MinGW/bin/mingwm10.dll
        C:/dev/MinGW/bin/pthreadGC2.dll
        # GDCM 2.x dependency
        ${GDCM_DIR}/../../bin/libvtkgdcm.dll
        ${GDCM_DIR}/../../bin/libgdcmcommon.dll
        ${GDCM_DIR}/../../bin/libgdcmcharls.dll
        ${GDCM_DIR}/../../bin/libgdcmdict.dll
        ${GDCM_DIR}/../../bin/libgdcmdsed.dll
        ${GDCM_DIR}/../../bin/libgdcmexpat.dll
        ${GDCM_DIR}/../../bin/libgdcmiod.dll
        ${GDCM_DIR}/../../bin/libgdcmjpeg12.dll
        ${GDCM_DIR}/../../bin/libgdcmjpeg16.dll
        ${GDCM_DIR}/../../bin/libgdcmjpeg8.dll
        ${GDCM_DIR}/../../bin/libgdcmmsff.dll
        ${GDCM_DIR}/../../bin/libgdcmopenjpeg.dll
        ${GDCM_DIR}/../../bin/libgdcmzlib.dll
        ${GDCM_DIR}/../../bin/libgdcmmsff.dll
        )
    endif()
      
      # MSVC compiler
    if (MSVC)
      
        message(STATUS "Packaging nsis using ${MAKENSIS} with MSVC compiler")

        set(CMAKE_INSTALL_SYSTEM_RUNTIME_LIBS 
        ##TODO use GetPrerequisites.cmake (i.e. find a better way to list dependencies)
        ##get_prerequisites() is not well enough documented to justify the time investement - EP May 2011
        # Qt dependencies
        ${QT_BINARY_DIR}/QtCore4.dll 
        ${QT_BINARY_DIR}/QtGui4.dll
        ${QT_BINARY_DIR}/QtSvg4.dll
        ${QT_BINARY_DIR}/QtXml4.dll
        ${QT_BINARY_DIR}/QtNetwork4.dll
        ${QT_BINARY_DIR}/QtSql4.dll
        ${QT_BINARY_DIR}/QtWebKit4.dll
        # VTK dependencies
        ${VTK_DIR}/../../bin/QVTK.dll 
        ${VTK_DIR}/../../bin/vtkCommon.dll 
        ${VTK_DIR}/../../bin/vtksys.dll 
        ${VTK_DIR}/../../bin/vtkFiltering.dll 
        ${VTK_DIR}/../../bin/vtkGraphics.dll 
        ${VTK_DIR}/../../bin/vtkHybrid.dll 
        ${VTK_DIR}/../../bin/vtkIO.dll 
        ${VTK_DIR}/../../bin/vtkImaging.dll
        ${VTK_DIR}/../../bin/vtkRendering.dll 
        ${VTK_DIR}/../../bin/vtkVolumeRendering.dll
        ${VTK_DIR}/../../bin/vtkverdict.dll 
        ${VTK_DIR}/../../bin/vtkDICOMParser.dll 
        ${VTK_DIR}/../../bin/vtkNetCDF.dll 
        ${VTK_DIR}/../../bin/vtkNetCDF_cxx.dll
        ${VTK_DIR}/../../bin/vtkexpat.dll 
        ${VTK_DIR}/../../bin/vtkjpeg.dll 
        ${VTK_DIR}/../../bin/vtkmetaio.dll 
        ${VTK_DIR}/../../bin/vtkpng.dll 
        ${VTK_DIR}/../../bin/vtktiff.dll 
        ${VTK_DIR}/../../bin/vtkzlib.dll 
        ${VTK_DIR}/../../bin/vtkInfovis.dll 
        ${VTK_DIR}/../../bin/vtkfreetype.dll 
        ${VTK_DIR}/../../bin/vtkftgl.dll
        ${VTK_DIR}/../../bin/vtkalglib.dll 
        ${VTK_DIR}/../../bin/vtklibxml2.dll 
        ${VTK_DIR}/../../bin/vtkViews.dll 
        ${VTK_DIR}/../../bin/vtkexoIIc.dll
        ${VTK_DIR}/../../bin/vtkWidgets.dll  
        ${VTK_DIR}/../../bin/vtkhdf5.dll 
        ${VTK_DIR}/../../bin/vtkhdf5_hl.dll 
        ${VTK_DIR}/../../bin/LSDyna.dll
        # Xerces-c dependency
        ${XERCESC_ROOT_DIR}/bin/xerces-c_3_1.dll 
        # Libxml2 dependencies
        ${LIBXML2_INCLUDE_DIR}/../bin/iconv.dll
        ${LIBXML2_INCLUDE_DIR}/../bin/libxml2.dll
        ${LIBXML2_INCLUDE_DIR}/../bin/zlib1.dll
        # ITK dependency 
        ${ITK_DIR}/../../bin/ITKCommon.dll
        # GDCM 2.x dependency
        ${GDCM_DIR}/../../bin/vtkgdcm.dll
        ${GDCM_DIR}/../../bin/gdcmcommon.dll
        ${GDCM_DIR}/../../bin/gdcmcharls.dll
        ${GDCM_DIR}/../../bin/gdcmdict.dll
        ${GDCM_DIR}/../../bin/gdcmdsed.dll
        ${GDCM_DIR}/../../bin/gdcmexpat.dll
        ${GDCM_DIR}/../../bin/gdcmiod.dll
        ${GDCM_DIR}/../../bin/gdcmjpeg12.dll
        ${GDCM_DIR}/../../bin/gdcmjpeg16.dll
        ${GDCM_DIR}/../../bin/gdcmjpeg8.dll
        ${GDCM_DIR}/../../bin/gdcmmsff.dll
        ${GDCM_DIR}/../../bin/gdcmopenjpeg.dll
        ${GDCM_DIR}/../../bin/gdcmzlib.dll
        ${GDCM_DIR}/../../bin/gdcmmsff.dll
        )
    endif()
      
    # Copy those dependencies DLLs if packaging on Windows.
    if (PACKAGING_NSIS)
        include(InstallRequiredSystemLibraries)
    endif()
            
    # Application icon
    set(CAMITK_PACKAGE_ICON "${CMAKE_CURRENT_SOURCE_DIR}\\\\sdk\\\\libraries\\\\core\\\\resources\\\\appIcon.ico") #set here the current icon for CamiTK
    set(CPACK_PACKAGE_ICON ${CAMITK_PACKAGE_ICON}) #icon for the top bar NSIS installer
    set(CPACK_NSIS_MUI_ICON ${CAMITK_PACKAGE_ICON}) #icon for the generated install program (the .exe to run to install CamiTK).
    set(CPACK_NSIS_MUI_UNIICON ${CAMITK_PACKAGE_ICON}) #icon for the generated uninstall program (the .exe to run to uninstall CamiTK).

    # Create desktop icons, by forcing CPack to build an internal command, as 'set(CPACK_NSIS_MODIFY_PATH ON)' option setted in the additional page doesn't work.
    set(CPACK_NSIS_EXTRA_INSTALL_COMMANDS "CreateShortCut \\\"$DESKTOP\\\\${CAMITK_PROJECT_NAME}-imp.lnk\\\" \\\"$INSTDIR\\\\bin\\\\imp.exe\\\"")              
        
    # Tell CPack to remove the icons after uninstalling
    set(CPACK_NSIS_EXTRA_UNINSTALL_COMMANDS "Delete \\\"$DESKTOP\\\\${CAMITK_PROJECT_NAME}-imp.lnk\\\"")
        
    # Installer name
    set(CPACK_NSIS_DISPLAY_NAME "CamiTK ${CAMITK_VERSION_MAJOR}.${CAMITK_VERSION_MINOR}.${CAMITK_VERSION_PATCH}")
    set(CPACK_NSIS_INSTALLED_ICON_NAME ${CAMITK_PROJECT_NAME})

    set(CPACK_PACKAGE_INSTALL_DIRECTORY ${CAMITK_PROJECT_NAME})
    set(CPACK_NSIS_HELP_LINK "http:\\\\\\\\camitk.imag.fr")
    set(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\camitk.imag.fr")
    set(CPACK_NSIS_CONTACT ${CPACK_PACKAGE_CONTACT})
      
    else()
        message(STATUS "Can not find makensis: nsis packaging is not possible")
    endif()

endif()

# ---------------
# Mac App Bundle
# ---------------
if(APPLE)
    # TODO test this!
    set(CPACK_GENERATOR "PackageMaker")
    # Libraries are bundled directly
    set(CPACK_COMPONENT_LIBRARIES_HIDDEN TRUE)
    # Bundle Properties
    set(MACOSX_BUNDLE_BUNDLE_NAME ${CPACK_PACKAGE_NAME})
    set(MACOSX_BUNDLE_BUNDLE_VERSION ${PROJECT_VERSION})
    set(MACOSX_BUNDLE_SHORT_VERSION_STRING ${PROJECT_VERSION})
    set(MACOSX_BUNDLE_LONG_VERSION_STRING "Version ${PROJECT_VERSION}")
endif()



# Set up CPack configuration
include(CPack)

# Create the groups that will contains the installer components
cpack_add_component_group(SDK
                          DISPLAY_NAME "CamiTK SDK"
                          DESCRIPTION "The CamiTK SDK features the core and basics extensions. CamiTK installation requires at least the SDK"
                          BOLD_TITLE
                          )
cpack_add_component_group(CEP_IMAGING
                          DISPLAY_NAME "CEP Imaging"
                          DESCRIPTION "The CamiTK Extension Project IMAGING contains image processing extensions. Those extensions are optional."
                          )
cpack_add_component_group(CEP_MODELING
                          DISPLAY_NAME "CEP Modeling"
                          DESCRIPTION "The CamiTK Extension Project MODELING contains biomechanical extensions. Those extensions are optional."
                          )

# ----------------------------------
# CamiTK specific packaging targets
# ----------------------------------

# create specific target for package source
# When packaging, copy the CamiTKPackageVersion.h file to the source directory
# Don't forget to remove it immediatly after packaging.
add_custom_target(camitk_package_source
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CMAKE_CURRENT_BINARY_DIR}/CamiTKPackageVersion.h
                ${CMAKE_CURRENT_SOURCE_DIR}/sdk/libraries/core/CamiTKVersion.h
    COMMAND ${CMAKE_COMMAND}
        --build ${CMAKE_BINARY_DIR}
        --target package_source
    COMMAND ${CMAKE_COMMAND}
        -E remove -f ${CMAKE_CURRENT_SOURCE_DIR}/sdk/libraries/core/CamiTKVersion.h
)

if(WIN32)
# create specific target for binary package
add_custom_target(camitk_package
    # Configure for packaging
    COMMAND ${CMAKE_COMMAND}
            -DPACKAGING_NSIS:BOOL=ON ${CMAKE_BINARY_DIR}
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h
                ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h-backup
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CMAKE_CURRENT_BINARY_DIR}/CamiTKPackageVersion.h
                ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h
    COMMAND ${CMAKE_COMMAND}
        --build ${CMAKE_BINARY_DIR}
        --target package --config Release
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h-backup
                ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h
    # Configure back for normal builds
    COMMAND ${CMAKE_COMMAND} -DPACKAGING_NSIS:BOOL=OFF ${CMAKE_BINARY_DIR}
)
else()  
add_custom_target(camitk_package
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h
                ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h-backup
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CMAKE_CURRENT_BINARY_DIR}/CamiTKPackageVersion.h
                ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h
    COMMAND ${CMAKE_COMMAND}
        --build ${CMAKE_BINARY_DIR}
        --target package 
    COMMAND ${CMAKE_COMMAND}
        -E copy ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h-backup
                ${CMAKE_CURRENT_BINARY_DIR}/sdk/libraries/core/CamiTKVersion.h
)
endif()
endmacro()