/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "DicomTreeComponentExtension.h"

// include generated components headers
#include "DicomTreeDirectoryComponent.h"

// Qt stuff
#include <QFileInfo>

using namespace camitk;

// --------------- Extension Declaration -------------------
Q_EXPORT_PLUGIN2(dicomtreecomponentextension, DicomTreeComponentExtension);

// --------------- GetFileExtensions -------------------
QStringList DicomTreeComponentExtension::getFileExtensions() const {
    QStringList ext;
    ext << "[directory]";

    return ext;
}

// --------------- Open -------------------
Component * DicomTreeComponentExtension::open(const QString & path) throw (AbortException) {

    return new DicomTreeDirectoryComponent(path);
}

// --------------- Save --------------------
bool DicomTreeComponentExtension::save(Component * component) const {
    // depending on the components managed by DicomComponentExtension, use
    // component->getPointSet() (for a MeshComponent derived class)
    // or component->getImageData() (for a ImageComponent derived class)
    // and save the data in the managed format in the file component->getFileName()

    return false;
}

// --------------- hasDataDirectory -------------------
bool DicomTreeComponentExtension::hasDataDirectory() const {
    return true;
}

