#ifndef __AUTHNLIB_OPENSSLGENERICUTIL_H_
#define __AUTHNLIB_OPENSSLGENERICUTIL_H_

#include <string>

namespace AuthN {
namespace OpenSSL {

  //helper method to trim the blank characters at the beginning and end of the string
  void trim_blank(std::string& str);

  // helper method to convert strings to uppercase
  std::string upper_string(const std::string& str);

  // helper method to convert strings to lowercase
  std::string lower_string(const std::string& str);

  // helper method to get hash of the subject of the X509 content
  std::string get_hash_from_x509str(const std::string& x509_str);

  std::string GetOpenSSLError(int err = 0);

}
}


#endif /* __AUTHNLIB_OPENSSLGENERICUTIL_H_ */
