{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAngularDampingFactor: Single;
    procedure SetAngularDampingFactor(const Value: Single);
    function GetAngularVelocity: TVector3;
    procedure SetAngularVelocity(const Value: TVector3);
    function GetAutoDamp: boolean;
    procedure SetAutoDamp(const Value: boolean);
    function GetAutoDisable: boolean;
    procedure SetAutoDisable(const Value: boolean);
    function GetCenterOfMass: TVector3;
    procedure SetCenterOfMass(const Value: TVector3);
    function GetDisableAngularSpeed: Single;
    procedure SetDisableAngularSpeed(const Value: Single);
    function GetDisableLinearSpeed: Single;
    procedure SetDisableLinearSpeed(const Value: Single);
    function GetDisableTime: Single;
    procedure SetDisableTime(const Value: Single);
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    function GetFiniteRotationAxis: TVector3;
    procedure SetFiniteRotationAxis(const Value: TVector3);
    function GetFixed: boolean;
    procedure SetFixed(const Value: boolean);
    function GetInertia: TMatrix3;
    procedure SetInertia(const Value: TMatrix3);
    function GetLinearDampingFactor: Single;
    procedure SetLinearDampingFactor(const Value: Single);
    function GetLinearVelocity: TVector3;
    procedure SetLinearVelocity(const Value: TVector3);
    function GetMass: Single;
    procedure SetMass(const Value: Single);
    function GetOrientation: TVector4;
    procedure SetOrientation(const Value: TVector4);
    function GetPosition: TVector3;
    procedure SetPosition(const Value: TVector3);
    function GetUseFiniteRotation: boolean;
    procedure SetUseFiniteRotation(const Value: boolean);
    function GetUseGlobalGravity: boolean;
    procedure SetUseGlobalGravity(const Value: boolean);
  public
    property AngularDampingFactor: Single read GetAngularDampingFactor write SetAngularDampingFactor;
    property AngularVelocity: TVector3 read GetAngularVelocity write SetAngularVelocity;
    property AutoDamp: boolean read GetAutoDamp write SetAutoDamp;
    property AutoDisable: boolean read GetAutoDisable write SetAutoDisable;
    property CenterOfMass: TVector3 read GetCenterOfMass write SetCenterOfMass;
    property DisableAngularSpeed: Single read GetDisableAngularSpeed write SetDisableAngularSpeed;
    property DisableLinearSpeed: Single read GetDisableLinearSpeed write SetDisableLinearSpeed;
    property DisableTime: Single read GetDisableTime write SetDisableTime;
    property Enabled: boolean read GetEnabled write SetEnabled;
    property FiniteRotationAxis: TVector3 read GetFiniteRotationAxis write SetFiniteRotationAxis;
    property Fixed: boolean read GetFixed write SetFixed;
    procedure SetForces(const Value: array of TVector3);
    procedure SetForces(const Value: TVector3List);
    procedure SetGeometry(const Value: array of TAbstractNBodyCollidableNode);
    property Inertia: TMatrix3 read GetInertia write SetInertia;
    property LinearDampingFactor: Single read GetLinearDampingFactor write SetLinearDampingFactor;
    property LinearVelocity: TVector3 read GetLinearVelocity write SetLinearVelocity;
    property Mass: Single read GetMass write SetMass;
    property Orientation: TVector4 read GetOrientation write SetOrientation;
    property Position: TVector3 read GetPosition write SetPosition;
    procedure SetTorques(const Value: array of TVector3);
    procedure SetTorques(const Value: TVector3List);
    property UseFiniteRotation: boolean read GetUseFiniteRotation write SetUseFiniteRotation;
    property UseGlobalGravity: boolean read GetUseGlobalGravity write SetUseGlobalGravity;

{$endif read_interface}

{$ifdef read_implementation}

{ TRigidBodyNode ----------------------------------------------- }

function TRigidBodyNode.GetAngularDampingFactor: Single;
begin
  Result := FdAngularDampingFactor.Value;
end;

procedure TRigidBodyNode.SetAngularDampingFactor(const Value: Single);
begin
  FdAngularDampingFactor.Send(Value);
end;

function TRigidBodyNode.GetAngularVelocity: TVector3;
begin
  Result := FdAngularVelocity.Value;
end;

procedure TRigidBodyNode.SetAngularVelocity(const Value: TVector3);
begin
  FdAngularVelocity.Send(Value);
end;

function TRigidBodyNode.GetAutoDamp: boolean;
begin
  Result := FdAutoDamp.Value;
end;

procedure TRigidBodyNode.SetAutoDamp(const Value: boolean);
begin
  FdAutoDamp.Send(Value);
end;

function TRigidBodyNode.GetAutoDisable: boolean;
begin
  Result := FdAutoDisable.Value;
end;

procedure TRigidBodyNode.SetAutoDisable(const Value: boolean);
begin
  FdAutoDisable.Send(Value);
end;

function TRigidBodyNode.GetCenterOfMass: TVector3;
begin
  Result := FdCenterOfMass.Value;
end;

procedure TRigidBodyNode.SetCenterOfMass(const Value: TVector3);
begin
  FdCenterOfMass.Send(Value);
end;

function TRigidBodyNode.GetDisableAngularSpeed: Single;
begin
  Result := FdDisableAngularSpeed.Value;
end;

procedure TRigidBodyNode.SetDisableAngularSpeed(const Value: Single);
begin
  FdDisableAngularSpeed.Send(Value);
end;

function TRigidBodyNode.GetDisableLinearSpeed: Single;
begin
  Result := FdDisableLinearSpeed.Value;
end;

procedure TRigidBodyNode.SetDisableLinearSpeed(const Value: Single);
begin
  FdDisableLinearSpeed.Send(Value);
end;

function TRigidBodyNode.GetDisableTime: Single;
begin
  Result := FdDisableTime.Value;
end;

procedure TRigidBodyNode.SetDisableTime(const Value: Single);
begin
  FdDisableTime.Send(Value);
end;

function TRigidBodyNode.GetEnabled: boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TRigidBodyNode.SetEnabled(const Value: boolean);
begin
  FdEnabled.Send(Value);
end;

function TRigidBodyNode.GetFiniteRotationAxis: TVector3;
begin
  Result := FdFiniteRotationAxis.Value;
end;

procedure TRigidBodyNode.SetFiniteRotationAxis(const Value: TVector3);
begin
  FdFiniteRotationAxis.Send(Value);
end;

function TRigidBodyNode.GetFixed: boolean;
begin
  Result := FdFixed.Value;
end;

procedure TRigidBodyNode.SetFixed(const Value: boolean);
begin
  FdFixed.Send(Value);
end;

procedure TRigidBodyNode.SetForces(const Value: array of TVector3);
begin
  FdForces.Send(Value);
end;

procedure TRigidBodyNode.SetForces(const Value: TVector3List);
begin
  FdForces.Send(Value);
end;

procedure TRigidBodyNode.SetGeometry(const Value: array of TAbstractNBodyCollidableNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractNBodyCollidableNode));
  FdGeometry.Send(A);
end;

function TRigidBodyNode.GetInertia: TMatrix3;
begin
  Result := FdInertia.Value;
end;

procedure TRigidBodyNode.SetInertia(const Value: TMatrix3);
begin
  FdInertia.Send(Value);
end;

function TRigidBodyNode.GetLinearDampingFactor: Single;
begin
  Result := FdLinearDampingFactor.Value;
end;

procedure TRigidBodyNode.SetLinearDampingFactor(const Value: Single);
begin
  FdLinearDampingFactor.Send(Value);
end;

function TRigidBodyNode.GetLinearVelocity: TVector3;
begin
  Result := FdLinearVelocity.Value;
end;

procedure TRigidBodyNode.SetLinearVelocity(const Value: TVector3);
begin
  FdLinearVelocity.Send(Value);
end;

function TRigidBodyNode.GetMass: Single;
begin
  Result := FdMass.Value;
end;

procedure TRigidBodyNode.SetMass(const Value: Single);
begin
  FdMass.Send(Value);
end;

function TRigidBodyNode.GetOrientation: TVector4;
begin
  Result := FdOrientation.Value;
end;

procedure TRigidBodyNode.SetOrientation(const Value: TVector4);
begin
  FdOrientation.Send(Value);
end;

function TRigidBodyNode.GetPosition: TVector3;
begin
  Result := FdPosition.Value;
end;

procedure TRigidBodyNode.SetPosition(const Value: TVector3);
begin
  FdPosition.Send(Value);
end;

procedure TRigidBodyNode.SetTorques(const Value: array of TVector3);
begin
  FdTorques.Send(Value);
end;

procedure TRigidBodyNode.SetTorques(const Value: TVector3List);
begin
  FdTorques.Send(Value);
end;

function TRigidBodyNode.GetUseFiniteRotation: boolean;
begin
  Result := FdUseFiniteRotation.Value;
end;

procedure TRigidBodyNode.SetUseFiniteRotation(const Value: boolean);
begin
  FdUseFiniteRotation.Send(Value);
end;

function TRigidBodyNode.GetUseGlobalGravity: boolean;
begin
  Result := FdUseGlobalGravity.Value;
end;

procedure TRigidBodyNode.SetUseGlobalGravity(const Value: boolean);
begin
  FdUseGlobalGravity.Send(Value);
end;

{$endif read_implementation}
