            "################################################################################\n"
            "## CFEngine Bootstrap / Failsafe Policy ########################################\n"
            "################################################################################\n"
            "# THIS FILE REPRESENTS A FALL-BACK SOLUTION FOR THE PRIMARY FAILSAFE FILE.\n"
            "# IF THE PRIMARY FAILSAFE/UPDATE LOSES FUNCTIONALITY DUE TO MODIFICATIONS MADE\n"
            "# BY THE USER, CFENGINE WILL RECOVER BY USING THIS FALL-BACK BOOTSTRAPPED FILE.\n"
            "# NEVER EDIT THIS FILE, YOU WILL HAVE TO LOG ON TO EVERY NODE MANAGED BY\n"
            "# CFENGINE TO RECTIFY POTENTIAL ERRORS IF SOMETHING GOES WRONG.\n"
            "################################################################################\n"
            "\n"
            "body common control\n"
            "{\n"
            "      bundlesequence => { \"cfe_internal_update\", \"cfe_internal_call_update\" };\n"
            "}\n"
            "\n"
            "################################################################################\n"
            "\n"
            "body agent control\n"
            "{\n"
            "      skipidentify => \"true\";\n"
            "}\n"
            "\n"
            "################################################################################\n"
            "\n"
            "bundle agent cfe_internal_update\n"
            "{\n"
            "  classes:\n"
            "\n"
            "    any::\n"
            "\n"
            "      \"have_ppkeys\"\n"
            "      expression => fileexists(\"$(sys.workdir)/ppkeys/localhost.pub\"),\n"
            "      handle => \"cfe_internal_bootstrap_update_classes_have_ppkeys\";\n"
            "\n"
            "      \"have_promises_cf\"\n"
            "      expression => fileexists(\"$(sys.inputdir)/promises.cf\"),\n"
            "      handle => \"cfe_internal_bootstrap_update_classes_have_promises_cf\";\n"
            "\n"
            "      #\n"
            "\n"
            "  commands:\n"
            "\n"
            "    !have_ppkeys::\n"
            "\n"
            "      \"$(sys.cf_key)\"\n"
            "      handle => \"cfe_internal_bootstrap_update_commands_generate_keys\";\n"
            "\n"
            "      #\n"
            "\n"
            "  files:\n"
            "\n"
            "    !windows.have_ppkeys::\n"
            "\n"
            "      \"$(sys.inputdir)\"\n"
            "      handle => \"cfe_internal_bootstrap_update_files_sys_workdir_inputs_not_windows\",\n"
            "      copy_from => u_scp(\"$(sys.masterdir)\"),\n"
            "      depth_search => u_recurse(\"inf\"),\n"
            "      classes => repaired(\"got_policy\");\n"
            "\n"
            "    windows.have_ppkeys::\n"
            "\n"
            "      \"$(sys.inputdir)\"\n"
            "      handle => \"cfe_internal_bootstrap_update_files_sys_workdir_inputs_windows\",\n"
            "      copy_from => u_scp(\"/var/cfengine/masterfiles\"), # Not $(sys.masterdir) when referring to remote host.\n"
            "      depth_search => u_recurse(\"inf\"),\n"
            "      classes => repaired(\"got_policy\");\n"
            "\n"
            "      \"$(sys.workdir)\\\\bin-twin\\\\.\"\n"
            "      handle => \"cfe_internal_bootstrap_update_files_sys_workdir_bin_twin_windows\",\n"
            "      comment => \"Make sure we maintain a clone of the binaries and libraries for updating\",\n"
            "      copy_from => u_cp(\"$(sys.workdir)\\\\bin\\\\.\"),\n"
            "      depth_search => u_recurse(\"1\");\n"
            "\n"
            "      #\n"
            "\n"
            "  processes:\n"
            "\n"
            "    !windows.got_policy::\n"
            "\n"
            "      \"cf-execd\" restart_class => \"start_exec\",\n"
            "      handle => \"cfe_internal_bootstrap_update_processes_start_cf_execd\";\n"
            "\n"
            "    am_policy_hub.got_policy::\n"
            "\n"
            "      \"cf-serverd\" restart_class => \"start_server\",\n"
            "      handle => \"cfe_internal_bootstrap_update_processes_start_cf_serverd\";\n"
            "\n"
            "      #\n"
            "\n"
            "  commands:\n"
            "\n"
            "    start_exec.!windows::\n"
            "\n"
            "      \"$(sys.cf_execd)\"\n"
            "      handle => \"cfe_internal_bootstrap_update_commands_check_sys_cf_execd_start\",\n"
            "      classes => repaired(\"executor_started\");\n"
            "\n"
            "    start_server::\n"
            "\n"
            "      \"$(sys.cf_serverd)\"\n"
            "      handle => \"cfe_internal_bootstrap_update_commands_check_sys_cf_serverd_start\",\n"
            "      action => ifwin_bg,\n"
            "      classes => repaired(\"server_started\");\n"
            "\n"
            "      #\n"
            "\n"
            "  services:\n"
            "\n"
            "    windows.got_policy::\n"
            "\n"
            "      \"CfengineNovaExec\"\n"
            "      handle => \"cfe_internal_bootstrap_update_services_windows_executor\",\n"
            "      service_policy => \"start\",\n"
            "      service_method => bootstart,\n"
            "      classes => repaired(\"executor_started\");\n"
            "\n"
            "      #\n"
            "\n"
            "  reports:\n"
            "\n"
            "    bootstrap_mode.am_policy_hub::\n"
            "\n"
            "      \"This host assumes the role of policy server\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_assume_policy_hub\";\n"
            "\n"
            "    bootstrap_mode.!am_policy_hub::\n"
            "\n"
            "      \"This autonomous node assumes the role of voluntary client\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_assume_voluntary_client\";\n"
            "\n"
            "    got_policy::\n"
            "\n"
            "      \"Updated local policy from policy server\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_got_policy\";\n"
            "\n"
            "    !got_policy.!have_promises_cf.have_ppkeys::\n"
            "\n"
            "      \"Failed to copy policy from policy server at $(sys.policy_hub):$(sys.masterdir)\n"
            "       Please check\n"
            "       * cf-serverd is running on $(sys.policy_hub)\n"
            "       * network connectivity to $(sys.policy_hub) on port 5308\n"
            "       * masterfiles 'body server control' - in particular allowconnects, trustkeysfrom and skipverify\n"
            "       * masterfiles 'bundle server' -> access: -> masterfiles -> admit/deny\n"
            "       It is often useful to restart cf-serverd in verbose mode (cf-serverd -v) on $(sys.policy_hub) to diagnose connection issues.\n"
            "       When updating masterfiles, wait (usually 5 minutes) for files to propagate to inputs on $(sys.policy_hub) before retrying.\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_did_not_get_policy\";\n"
            "\n"
            "    server_started::\n"
            "\n"
            "      \"Started the server\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_started_serverd\";\n"
            "\n"
            "    am_policy_hub.!server_started.!have_promises_cf.have_ppkeys::\n"
            "\n"
            "      \"Failed to start the server\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_failed_to_start_serverd\";\n"
            "\n"
            "    executor_started::\n"
            "\n"
            "      \"Started the scheduler\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_started_execd\";\n"
            "\n"
            "    !executor_started.!have_promises_cf.have_ppkeys::\n"
            "\n"
            "      \"Did not start the scheduler\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_failed_to_start_execd\";\n"
            "\n"
            "    !executor_started.have_promises_cf::\n"
            "\n"
            "      \"You are running a hard-coded failsafe. Please use the following command instead.\n"
            "        $(sys.cf_agent) -f $(sys.inputdir)/update.cf\"\n"
            "      handle => \"cfe_internal_bootstrap_update_reports_run_another_failsafe_instead\";\n"
            "      \n"
            "}\n"
            "\n"
            "################################################################################\n"
            "bundle agent cfe_internal_call_update\n"
            "{\n"
            "  commands:\n"
            "\n"
            "    # On Windows we need cf-execd to call update.cf, otherwise the daemons will\n"
            "    # not run under the SYSTEM account.\n"
            "    !windows::\n"
            "\n"
            "      \"$(sys.cf_agent) -f update.cf\"\n"
            "      handle => \"cfe_internal_call_update_commands_call_update_cf\";\n"
            "\n"
            "}\n"
            "############################################\n"
            "body classes repaired(x)\n"
            "{\n"
            "      promise_repaired => {\"$(x)\"};\n"
            "}\n"
            "############################################\n"
            "body perms u_p(p)\n"
            "{\n"
            "      mode  => \"$(p)\";\n"
            "}\n"
            "#############################################\n"
            "body copy_from u_scp(from)\n"
            "{\n"
            "      source      => \"$(from)\";\n"
            "      compare     => \"digest\";\n"
            "      trustkey    => \"true\";\n"
            "    !am_policy_hub::\n"
            "      servers => { \"$(sys.policy_hub)\" };\n"
            "}\n"
            "############################################\n"
            "body action u_background\n"
            "{\n"
            "      background => \"true\";\n"
            "}\n"
            "############################################\n"
            "body depth_search u_recurse(d)\n"
            "{\n"
            "      depth => \"$(d)\";\n"
            "      exclude_dirs => { \"\\.svn\", \"\\.git\" };\n"
            "}\n"
            "############################################\n"
            "body service_method bootstart\n"
            "{\n"
            "      service_autostart_policy => \"boot_time\";\n"
            "}\n"
            "############################################\n"
            "body action ifwin_bg\n"
            "{\n"
            "    windows::\n"
            "      background => \"true\";\n"
            "}\n"
            "############################################\n"
            "body copy_from u_cp(from)\n"
            "{\n"
            "      source          => \"$(from)\";\n"
            "      compare         => \"digest\";\n"
            "      copy_backup     => \"false\";\n"
            "}\n"
