<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Member/MembershipLog.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:9182bcbeed0a05c3fed5f3027ba89668)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Member_DAO_MembershipLog constructor.
 */
class CRM_Member_DAO_MembershipLog extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_membership_log';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   *
   * @var int unsigned
   */
  public $id;
  /**
   * FK to Membership table
   *
   * @var int unsigned
   */
  public $membership_id;
  /**
   * New status assigned to membership by this action. FK to Membership Status
   *
   * @var int unsigned
   */
  public $status_id;
  /**
   * New membership period start date
   *
   * @var date
   */
  public $start_date;
  /**
   * New membership period expiration date.
   *
   * @var date
   */
  public $end_date;
  /**
   * FK to Contact ID of person under whose credentials this data modification was made.
   *
   * @var int unsigned
   */
  public $modified_id;
  /**
   * Date this membership modification action was logged.
   *
   * @var date
   */
  public $modified_date;
  /**
   * FK to Membership Type.
   *
   * @var int unsigned
   */
  public $membership_type_id;
  /**
   * Maximum number of related memberships.
   *
   * @var int
   */
  public $max_related;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_membership_log';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'membership_id', 'civicrm_membership', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'status_id', 'civicrm_membership_status', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'modified_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'membership_type_id', 'civicrm_membership_type', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Membership Log ID') ,
          'required' => true,
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
        ) ,
        'membership_id' => array(
          'name' => 'membership_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Membership ID') ,
          'description' => 'FK to Membership table',
          'required' => true,
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
          'FKClassName' => 'CRM_Member_DAO_Membership',
        ) ,
        'status_id' => array(
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Membership Status') ,
          'description' => 'New status assigned to membership by this action. FK to Membership Status',
          'required' => true,
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
          'FKClassName' => 'CRM_Member_DAO_MembershipStatus',
        ) ,
        'start_date' => array(
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Membership Log Start Date') ,
          'description' => 'New membership period start date',
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
        ) ,
        'end_date' => array(
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Membership Log End Date') ,
          'description' => 'New membership period expiration date.',
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
        ) ,
        'modified_id' => array(
          'name' => 'modified_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Membership Log modified By') ,
          'description' => 'FK to Contact ID of person under whose credentials this data modification was made.',
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ) ,
        'modified_date' => array(
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Membership Change Date') ,
          'description' => 'Date this membership modification action was logged.',
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
        ) ,
        'membership_type_id' => array(
          'name' => 'membership_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Membership Type ID') ,
          'description' => 'FK to Membership Type.',
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
          'FKClassName' => 'CRM_Member_DAO_MembershipType',
        ) ,
        'max_related' => array(
          'name' => 'max_related',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Maximum Related Memberships') ,
          'description' => 'Maximum number of related memberships.',
          'table_name' => 'civicrm_membership_log',
          'entity' => 'MembershipLog',
          'bao' => 'CRM_Member_BAO_MembershipLog',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'membership_log', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'membership_log', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array();
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
