/*
//
//  Copyright 2010 Torsten Rohlfing
//
//  Copyright 2010 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 2398 $
//
//  $LastChangedDate: 2010-10-05 14:54:37 -0700 (Tue, 05 Oct 2010) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#ifndef __cmtkImageOperationConnectedComponents_h_included_
#define __cmtkImageOperationConnectedComponents_h_included_

#include <cmtkconfig.h>

#include <Base/cmtkImageOperation.h>
#include <Base/cmtkDataGridMorphologicalOperators.h>

namespace
cmtk
{

/// Image operation: create connected components map.
class ImageOperationConnectedComponents
/// Inherit from image operation base class.
  : public ImageOperation
{
public:
  /// Apply this operation to an image in place.
  virtual cmtk::UniformVolume::SmartPtr  Apply( cmtk::UniformVolume::SmartPtr& volume )
  {
    cmtk::DataGridMorphologicalOperators ops( volume );
    volume->SetData( ops.GetBinaryConnectedComponents() );
    volume->SetData( ops.GetRegionsRenumberedBySize() );
    return volume;
  }
  
  /// Create new connected components operation.
  static void New()
  {
    ImageOperation::m_ImageOperationList.push_back( SmartPtr( new ImageOperationConnectedComponents() ) );
  }
};

} // namespace cmtk

#endif // #ifndef __cmtkImageOperationConnectedComponents_h_included_
