package org.apache.commons.javaflow.bytecode.transformation.data;

import java.util.Properties;

/**
 * A regression test case for handling null in the local variables.
 *
 * @author Kohsuke Kawaguchi
 */
public class NullVariableMethodFlow implements Runnable {

    public void run() {
        getLocalAddress(System.getProperties());
    }

    public static String getLocalAddress(Properties session) {
        String x = null, y;

        // when javaflow generates the store/load code around this invocation,
        // x is of the type 'null'. we have to restore the local variable
        // in the correct type (in particular not java/lang/Object, but "null")
        // or otherwise VerifyError occurs.
        y = session.getProperty("a");
        if (y == null) {
            x = session.getProperty("b");
        }

        if (y == null)
            y = x;

        return y;
    }
}
