# Based on gtest's GTEST_ADD_TESTS, but with run-with-xvfb.sh
function(ENV_GTEST_ADD_TESTS executable extra_args)
    if(NOT ARGN)
        message(FATAL_ERROR "Missing ARGN")
    endif()
    foreach(source ${ARGN})
        file(READ "${source}" contents)
        string(REGEX MATCHALL "TEST_?F?\\(([A-Za-z_0-9 ,]+)\\)" found_tests ${contents})
        foreach(hit ${found_tests})
            string(REGEX REPLACE ".*\\( *([A-Za-z_0-9]+), *([A-Za-z_0-9]+) *\\).*" "\\1.\\2" test_name ${hit})
            add_test(${test_name} "/bin/bash" "${CMAKE_SOURCE_DIR}/scripts/run-with-xvfb.sh" "./${executable} --gtest_filter=${test_name} ${extra_args}")
        endforeach()
    endforeach()
endfunction()
