/*
 *  Copyright 2011 Wolfgang Koller - http://www.gofg.at/
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var _notificationBusy = false;

function Notification() {
}

function _showNotificationDialog(method, args, cb) {
    (function f1() {
        if (_notificationBusy) {
            setTimeout(f1, 150);
            return;
        }
        _notificationBusy = true;
        Cordova.exec(function(id, text) {
            _notificationBusy = false;
            cb(id, text);
        }, null, "com.cordova.Notification", method, args);
    })();
}

Notification.prototype.alert = function(message, alertCallback, title, buttonName) {
    if (!title)
        title = "Alert";
    if (!buttonName)
       buttonName = "OK";
    this.confirm(message, alertCallback, title, buttonName);
}

Notification.prototype.confirm = function(message, confirmCallback, title, buttonLabels) {
    if (!title)
        title = "Confirm";
    if (typeof(buttonLabels) === "string" ) {
        buttonLabels = buttonLabels.split(',').filter(function(str) {return str.length});
    } else {
        throw new Error("argument error");
    }
    if (!buttonLabels)
       buttonLabels = ["OK", "Cancel"];
    if (buttonLabels.length > 3)
       throw new Error("unsupported more then 3 buttons");
    _showNotificationDialog("confirm", [message, title, buttonLabels], confirmCallback);
}

Notification.prototype.prompt = function(message, confirmCallback, title, buttonLabels, defaultText) {
    if (!title)
        title = "Prompt";
    if (!buttonLabels)
       buttonLabels = ["OK", "Cancel"];
    if (buttonLabels.length > 3)
       throw new Error("unsupported more then 3 buttons");
    _showNotificationDialog("prompt", [message, title, buttonLabels, defaultText], confirmCallback);
}

Notification.prototype.beep = function(times) {
    Cordova.exec(null, null, "com.cordova.Notification", "beep", [times]);
}

Notification.prototype.vibrate = function(milliseconds) {
    Cordova.exec(null, null, "com.cordova.Notification", "vibrate", [milliseconds]);
}

Cordova.addConstructor("com.cordova.Notification", function () {
    navigator.notification = new Notification();
});
