#ifndef SESSION_MANAGER_H__
#define SESSION_MANAGER_H__

#include "../dcpp/stdinc.h"
#include "../dcpp/DCPlusPlus.h"
#include "../dcpp/User.h"
#include "../dcpp/Util.h"
#include "../dcpp/Client.h"
#include <dcpp/ClientManager.h>
#include "../dcpp/ClientManagerListener.h"
#include "../dcpp/HashManager.h"
#include "../dcpp/TimerManager.h"
#include <dcpp/HubManager.h>

#include "Session.h"
#include "User.h"

#include <pthread.h>
#include "Stack.h"
#include <ext/hash_map>
#include <boost/thread/recursive_mutex.hpp>

namespace dcqt_backend {

//! Provides mapping between dc++ Client objects and our own Session's.
class SessionManager : public ClientManagerListener, public TimerManagerListener, public HubManagerListener
{
public:

  virtual ~SessionManager();

  int createSession(const string& url);
  void closeSession(int);
  Session *getSession(int);
  Session *getSession(Client*);

  virtual void on(ClientManagerListener::ClientConnected, Client* c) throw();
  virtual void on(ClientManagerListener::ClientUpdated, Client* c) throw();
  virtual void on(ClientManagerListener::ClientDisconnected, Client* c) throw();
  virtual void on(TimerManagerListener::Second, u_int32_t) throw();
  virtual void on(HubManagerListener::DownloadStarting, const string&) throw();
  virtual void on(HubManagerListener::DownloadFailed, const string&) throw();
  virtual void on(HubManagerListener::DownloadFinished, const string&) throw();
  virtual void on(HubManagerListener::FavoriteAdded, const FavoriteHubEntry*) throw();
  virtual void on(HubManagerListener::FavoriteRemoved, const FavoriteHubEntry*) throw();
  
  static SessionManager* instance() {if(!inst) inst = new SessionManager;return inst;}

  map<int,Session*>* getSessionMap() { return &intSessionMap; }

  //void aquireLock();
  //void releaseLock();

  //! Used to map requests from the gui to a user, for example when clicking in the transfer view.
  typedef hash_map<int,::User::Ptr> IntUserPtrMap;
  //! Used to cache backend::User structs.
  typedef map< ::User::Ptr, dcqt_backend::User> UserPtrUserMap;

  UserPtrUserMap& getUserPtrMap() {return userPtrMap;}
  int generateUserId();
  IntUserPtrMap& getUserIdMap() {return userIdMap;}

	HubEntry::List getPublicHubs();
	void refreshHublist();
	FavoriteHubEntry::List& getFavouriteHubs();
    void addFavouriteHub(FavoriteHubEntry& entry);
    void removeFavouriteHub(string& server);
    
	boost::recursive_mutex sessionLock;
	
private:
  static SessionManager* inst;
  SessionManager();

  
  typedef map<Client*,Session*> ClientSessionMap;
  typedef map<int,Session*> IntSessionMap;


  ClientSessionMap clientSessionMap;
  IntSessionMap intSessionMap;

  int sessionIdCounter;

  // These two are part of the user id allocation scheme.
  int userIdCounter;
  Stack<int> userIdStack;
  IntUserPtrMap userIdMap;
  UserPtrUserMap userPtrMap;

  //pthread_mutex_t sessionLock;
  
  
  // Hashing
  int64_t hashBytesStart;
  bool hashingCompleted;
};
}

#endif
