# 💪 - 🔁 🏷

⏮️ **FastAPI**, 👆 💪 🔬, ✔, 📄, &amp; ⚙️ 🎲 🙇 🐦 🏷 (👏 Pydantic).

## 📇 🏑

👆 💪 🔬 🔢 🏾. 🖼, 🐍 `list`:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="14"
    {!> ../../../docs_src/body_nested_models/tutorial001.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="12"
    {!> ../../../docs_src/body_nested_models/tutorial001_py310.py!}
    ```

👉 🔜 ⚒ `tags` 📇, 👐 ⚫️ 🚫 📣 🆎 🔣 📇.

## 📇 🏑 ⏮️ 🆎 🔢

✋️ 🐍 ✔️ 🎯 🌌 📣 📇 ⏮️ 🔗 🆎, ⚖️ "🆎 🔢":

### 🗄 ⌨ `List`

🐍 3️⃣.9️⃣ &amp; 🔛 👆 💪 ⚙️ 🐩 `list` 📣 👫 🆎 ✍ 👥 🔜 👀 🔛. 👶

✋️ 🐍 ⏬ ⏭ 3️⃣.9️⃣ (3️⃣.6️⃣ &amp; 🔛), 👆 🥇 💪 🗄 `List` ⚪️➡️ 🐩 🐍 `typing` 🕹:

```Python hl_lines="1"
{!> ../../../docs_src/body_nested_models/tutorial002.py!}
```

### 📣 `list` ⏮️ 🆎 🔢

📣 🆎 👈 ✔️ 🆎 🔢 (🔗 🆎), 💖 `list`, `dict`, `tuple`:

* 🚥 👆 🐍 ⏬ 🔅 🌘 3️⃣.9️⃣, 🗄 👫 🌓 ⏬ ⚪️➡️ `typing` 🕹
* 🚶‍♀️ 🔗 🆎(Ⓜ) "🆎 🔢" ⚙️ ⬜ 🗜: `[` &amp; `]`

🐍 3️⃣.9️⃣ ⚫️ 🔜:

```Python
my_list: list[str]
```

⏬ 🐍 ⏭ 3️⃣.9️⃣, ⚫️ 🔜:

```Python
from typing import List

my_list: List[str]
```

👈 🌐 🐩 🐍 ❕ 🆎 📄.

⚙️ 👈 🎏 🐩 ❕ 🏷 🔢 ⏮️ 🔗 🆎.

, 👆 🖼, 👥 💪 ⚒ `tags` 🎯 "📇 🎻":

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="14"
    {!> ../../../docs_src/body_nested_models/tutorial002.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="14"
    {!> ../../../docs_src/body_nested_models/tutorial002_py39.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="12"
    {!> ../../../docs_src/body_nested_models/tutorial002_py310.py!}
    ```

## ⚒ 🆎

✋️ ⤴️ 👥 💭 🔃 ⚫️, &amp; 🤔 👈 🔖 🚫🔜 🚫 🔁, 👫 🔜 🎲 😍 🎻.

&amp; 🐍 ✔️ 🎁 💽 🆎 ⚒ 😍 🏬, `set`.

⤴️ 👥 💪 📣 `tags` ⚒ 🎻:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="1  14"
    {!> ../../../docs_src/body_nested_models/tutorial003.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="14"
    {!> ../../../docs_src/body_nested_models/tutorial003_py39.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="12"
    {!> ../../../docs_src/body_nested_models/tutorial003_py310.py!}
    ```

⏮️ 👉, 🚥 👆 📨 📨 ⏮️ ❎ 📊, ⚫️ 🔜 🗜 ⚒ 😍 🏬.

&amp; 🕐❔ 👆 🔢 👈 📊, 🚥 ℹ ✔️ ❎, ⚫️ 🔜 🔢 ⚒ 😍 🏬.

&amp; ⚫️ 🔜 ✍ / 📄 ➡️ 💁‍♂️.

## 🐦 🏷

🔠 🔢 Pydantic 🏷 ✔️ 🆎.

✋️ 👈 🆎 💪 ⚫️ ➕1️⃣ Pydantic 🏷.

, 👆 💪 📣 🙇 🐦 🎻 "🎚" ⏮️ 🎯 🔢 📛, 🆎 &amp; 🔬.

🌐 👈, 🎲 🐦.

### 🔬 📊

🖼, 👥 💪 🔬 `Image` 🏷:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="9-11"
    {!> ../../../docs_src/body_nested_models/tutorial004.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="9-11"
    {!> ../../../docs_src/body_nested_models/tutorial004_py39.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="7-9"
    {!> ../../../docs_src/body_nested_models/tutorial004_py310.py!}
    ```

### ⚙️ 📊 🆎

&amp; ⤴️ 👥 💪 ⚙️ ⚫️ 🆎 🔢:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="20"
    {!> ../../../docs_src/body_nested_models/tutorial004.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="20"
    {!> ../../../docs_src/body_nested_models/tutorial004_py39.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="18"
    {!> ../../../docs_src/body_nested_models/tutorial004_py310.py!}
    ```

👉 🔜 ⛓ 👈 **FastAPI** 🔜 ⌛ 💪 🎏:

```JSON
{
    "name": "Foo",
    "description": "The pretender",
    "price": 42.0,
    "tax": 3.2,
    "tags": ["rock", "metal", "bar"],
    "image": {
        "url": "http://example.com/baz.jpg",
        "name": "The Foo live"
    }
}
```

🔄, 🤸 👈 📄, ⏮️ **FastAPI** 👆 🤚:

* 👨‍🎨 🐕‍🦺 (🛠️, ♒️), 🐦 🏷
* 💽 🛠️
* 💽 🔬
* 🏧 🧾

## 🎁 🆎 &amp; 🔬

↖️ ⚪️➡️ 😐 ⭐ 🆎 💖 `str`, `int`, `float`, ♒️. 👆 💪 ⚙️ 🌅 🏗 ⭐ 🆎 👈 😖 ⚪️➡️ `str`.

👀 🌐 🎛 👆 ✔️, 🛒 🩺 <a href="https://pydantic-docs.helpmanual.io/usage/types/" class="external-link" target="_blank">Pydantic 😍 🆎</a>. 👆 🔜 👀 🖼 ⏭ 📃.

🖼, `Image` 🏷 👥 ✔️ `url` 🏑, 👥 💪 📣 ⚫️ ↩️ `str`, Pydantic `HttpUrl`:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="4  10"
    {!> ../../../docs_src/body_nested_models/tutorial005.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="4  10"
    {!> ../../../docs_src/body_nested_models/tutorial005_py39.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="2  8"
    {!> ../../../docs_src/body_nested_models/tutorial005_py310.py!}
    ```

🎻 🔜 ✅ ☑ 📛, &amp; 📄 🎻 🔗 / 🗄 ✅.

## 🔢 ⏮️ 📇 📊

👆 💪 ⚙️ Pydantic 🏷 🏾 `list`, `set`, ♒️:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="20"
    {!> ../../../docs_src/body_nested_models/tutorial006.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="20"
    {!> ../../../docs_src/body_nested_models/tutorial006_py39.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="18"
    {!> ../../../docs_src/body_nested_models/tutorial006_py310.py!}
    ```

👉 🔜 ⌛ (🗜, ✔, 📄, ♒️) 🎻 💪 💖:

```JSON hl_lines="11"
{
    "name": "Foo",
    "description": "The pretender",
    "price": 42.0,
    "tax": 3.2,
    "tags": [
        "rock",
        "metal",
        "bar"
    ],
    "images": [
        {
            "url": "http://example.com/baz.jpg",
            "name": "The Foo live"
        },
        {
            "url": "http://example.com/dave.jpg",
            "name": "The Baz"
        }
    ]
}
```

!!! info
    👀 ❔ `images` 🔑 🔜 ✔️ 📇 🖼 🎚.

## 🙇 🐦 🏷

👆 💪 🔬 🎲 🙇 🐦 🏷:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="9  14  20  23  27"
    {!> ../../../docs_src/body_nested_models/tutorial007.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="9  14  20  23  27"
    {!> ../../../docs_src/body_nested_models/tutorial007_py39.py!}
    ```

=== "🐍 3️⃣.1️⃣0️⃣ &amp; 🔛"

    ```Python hl_lines="7  12  18  21  25"
    {!> ../../../docs_src/body_nested_models/tutorial007_py310.py!}
    ```

!!! info
    👀 ❔ `Offer` ✔️ 📇 `Item`Ⓜ, ❔ 🔄 ✔️ 📦 📇 `Image`Ⓜ

## 💪 😁 📇

🚥 🔝 🎚 💲 🎻 💪 👆 ⌛ 🎻 `array` (🐍 `list`), 👆 💪 📣 🆎 🔢 🔢, 🎏 Pydantic 🏷:

```Python
images: List[Image]
```

⚖️ 🐍 3️⃣.9️⃣ &amp; 🔛:

```Python
images: list[Image]
```

:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="15"
    {!> ../../../docs_src/body_nested_models/tutorial008.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="13"
    {!> ../../../docs_src/body_nested_models/tutorial008_py39.py!}
    ```

## 👨‍🎨 🐕‍🦺 🌐

&amp; 👆 🤚 👨‍🎨 🐕‍🦺 🌐.

🏬 🔘 📇:

<img src="/img/tutorial/body-nested-models/image01.png">

👆 🚫 🚫 🤚 👉 😇 👨‍🎨 🐕‍🦺 🚥 👆 👷 🔗 ⏮️ `dict` ↩️ Pydantic 🏷.

✋️ 👆 🚫 ✔️ 😟 🔃 👫 👯‍♂️, 📨 #️⃣ 🗜 🔁 &amp; 👆 🔢 🗜 🔁 🎻 💁‍♂️.

## 💪 ❌ `dict`Ⓜ

👆 💪 📣 💪 `dict` ⏮️ 🔑 🆎 &amp; 💲 🎏 🆎.

🍵 ✔️ 💭 ⏪ ⚫️❔ ☑ 🏑/🔢 📛 (🔜 💼 ⏮️ Pydantic 🏷).

👉 🔜 ⚠ 🚥 👆 💚 📨 🔑 👈 👆 🚫 ⏪ 💭.

---

🎏 ⚠ 💼 🕐❔ 👆 💚 ✔️ 🔑 🎏 🆎, ✅ `int`.

👈 ⚫️❔ 👥 🔜 👀 📥.

👉 💼, 👆 🔜 🚫 🙆 `dict` 📏 ⚫️ ✔️ `int` 🔑 ⏮️ `float` 💲:

=== "🐍 3️⃣.6️⃣ &amp; 🔛"

    ```Python hl_lines="9"
    {!> ../../../docs_src/body_nested_models/tutorial009.py!}
    ```

=== "🐍 3️⃣.9️⃣ &amp; 🔛"

    ```Python hl_lines="7"
    {!> ../../../docs_src/body_nested_models/tutorial009_py39.py!}
    ```

!!! tip
    ✔️ 🤯 👈 🎻 🕴 🐕‍🦺 `str` 🔑.

    ✋️ Pydantic ✔️ 🏧 💽 🛠️.

    👉 ⛓ 👈, ✋️ 👆 🛠️ 👩‍💻 💪 🕴 📨 🎻 🔑, 📏 👈 🎻 🔌 😁 🔢, Pydantic 🔜 🗜 👫 &amp; ✔ 👫.

     &amp; `dict` 👆 📨 `weights` 🔜 🤙 ✔️ `int` 🔑 &amp; `float` 💲.

## 🌃

⏮️ **FastAPI** 👆 ✔️ 🔆 💪 🚚 Pydantic 🏷, ⏪ 🚧 👆 📟 🙅, 📏 &amp; 😍.

✋️ ⏮️ 🌐 💰:

* 👨‍🎨 🐕‍🦺 (🛠️ 🌐 ❗)
* 💽 🛠️ (.Ⓜ.. ✍ / 🛠️)
* 💽 🔬
* 🔗 🧾
* 🏧 🩺
