#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Toggle debug mode"

    def run(self):
        current_level = self.get_setting("general", "debug_level", "0")

        # Present current debug level
        if current_level == "0":
            self.present_text("Current debug mode: disabled")
            new_level = "1"
            state_text = "enabled"
        else:
            self.present_text(f"Current debug level: {current_level}")
            new_level = "0"
            state_text = "disabled"

        success = self.set_setting("general", "debug_level", new_level)

        if success:
            self.present_text(f"Debug mode {state_text}")
            if new_level != "0":
                debug_mode = self.get_setting("general", "debug_mode", "File")
                if debug_mode == "File":
                    self.present_text(
                        "Debug output will be written to log file"
                    )
                else:
                    self.present_text(
                        "Debug output will be printed to console"
                    )
            self.play_sound("Accept")
        else:
            self.present_text("Failed to change debug mode")
            self.play_sound("Error")
