package latexDraw.util;

import latexDraw.lang.LaTeXDrawLang;

/** 
 * This class allows the management of exceptions.
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class LaTeXDrawException extends Exception
{
	private static final long serialVersionUID = 1L;

	/** The code of the exception generated */
	private int errorCode;
	
	public static final short INCORRECT_VALUE      = 0;
	public static final short NOT_TEXDRAW_FILE     = 1;
	public static final short INVALID_TEXDRAW_VERSION = 2;
	public static final short INVALID_PICTURE 		= 3;
	
	
	/**
	 * The constructor using the identifier of the error
	 * @param errorCode The identifier of the error
	 */
	public LaTeXDrawException(int errorCode)
	{ 
		this.errorCode = errorCode; 
	}
	
	
	
	/**
	 * Allows to get the code of the error
	 * @return The code of the error
	 */
	public int getErrorCode() 
	{ 
		return errorCode; 
	}
	
	
	
	@Override
	public String toString()
	{
		switch(errorCode)
		{			
			case INCORRECT_VALUE      		: return LaTeXDrawLang.getOthersString("LaTeXDrawException.valueInc"); //$NON-NLS-1$
			case NOT_TEXDRAW_FILE   		: return LaTeXDrawLang.getOthersString("LaTeXDrawException.invFile"); //$NON-NLS-1$
			case INVALID_TEXDRAW_VERSION 	: return LaTeXDrawLang.getOthersString("LaTeXDrawException.invLaTeXDrawVer"); //$NON-NLS-1$
			case INVALID_PICTURE 			: return LaTeXDrawLang.getString1_7("LaTeXDrawException.0"); //$NON-NLS-1$
			
			default  : return LaTeXDrawLang.getOthersString("LaTeXDrawException.invException"); //$NON-NLS-1$
		}
	}
}
