#ifndef __OUTPUT_H__ /* file wrapper */
#define __OUTPUT_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 *
 * General output (a'la printf, etc.) routines that can do conversion
 * to various Japanese encoding methods.
 *
 * Probably won't really work if USE_LOCAL_OUTPUT isn't set.
 */

#if !defined(__GNUC__)
#  if !defined(__volatile__)
#    define __volatile__ /*nothing; for use with volatile functions */
#  endif
#  if !defined(__inline__)
#    define __inline__ /*nothing; for use with volatile functions */
#  endif
#endif

#ifndef USE_LOCAL_OUTPUT
#include <stdio.h>
 #define flush_output()	fflush(stdout)
 #define outputf 	printf
 #define output(string) fputs(string, stdout)
 #define outchar 	putchar
 #define select_output_style(foo)  (0)
 #define show_output_style()       /* nothing */
 #define OUTPUT_PAGER 0
 #define set_extra_output_file(fd)  (-1)
#else /* else USE_LOCAL_OUTPUT */

#if !PROVIDE_PAGER
 #define OUTPUT_PAGER 0
#else 
 #define OUTPUT_PAGER 1
 void output_pager_reset_more(void);
 int output_pager_transparent(int);
 unsigned output_pager_lines(unsigned);
 unsigned output_pager_columns(unsigned);
 int output_pager_status(int want);
#endif

extern void flush_output(void);
extern int outputf(const char *fmt, ...);
extern int output(const char *str);
extern unsigned (*_output_char_function)(unsigned char);
extern unsigned long select_output_style(unsigned long mods);
extern void show_output_style(void);
extern int set_extra_output_file(int fd);

#define INQUIRE_ONLY             0x00000000 /* just returns old code */

#define EUC_OUTPUT		 0x00000001
#define SJIS_OUTPUT		 0x00000002
#define JIS_OUTPUT		 0x00000004
#define _BASIC_OUTPUT_TYPE (JIS_OUTPUT|SJIS_OUTPUT|EUC_OUTPUT)

#define JIS_1978_OUTPUT		JIS_OUTPUT
#define JIS_1983_OUTPUT		JIS_OUTPUT|0x00000010
#define JIS_1990_OUTPUT		JIS_OUTPUT|0x00000020
#define _JIS_KANJI_STYLE (JIS_1978_OUTPUT|JIS_1978_OUTPUT|JIS_1990_OUTPUT)

#define JIS_ROMAN		0x00000100
#define JIS_ASCII		0x00000200
#define _JIS_ENGLISH_STYLE	(JIS_ROMAN|JIS_ASCII)

#define ELIDE_NONDISPLAYABLE		 0x00001000
#define OUTPUT_NONDISPLAYABLE		 0x00002000
#define SHOW_NONDISPLAYABLE_CODES	 0x00004000
#define MARK_NONDISPLAYABLE		 0x00008000
#define _NONDISPLAYABLE	(ELIDE_NONDISPLAYABLE|OUTPUT_NONDISPLAYABLE|\
			 SHOW_NONDISPLAYABLE_CODES|MARK_NONDISPLAYABLE)

#define PASS_HW_KATANANA		 0x00010000
#define ELIDE_HW_KATAKANA		 0x00020000
#define FOLD_HW_KATAKANA_TO_FULL	 0x00040000
#define _KATAKANA	(PASS_HW_KATANANA|ELIDE_HW_KATAKANA|\
			 FOLD_HW_KATAKANA_TO_FULL)

#define SUPPORT_0212_1990		 0x00100000
#define NO_0212_1990			 0x00200000
#define _0212_1990		(SUPPORT_0212_1990|NO_0212_1990)

#define outchar(c)  (*_output_char_function)((unsigned char)(c))
extern void output_pager_reset_more(void);
#endif /* end USE_LOCAL_OUTPUT */

extern __volatile__ void die(const char *fmt, ...);

extern void warn(const char *fmt, ...);

extern void output_buffer(const unsigned char *start,
			  const unsigned char *end);

#define OUTPUT_FILE_ERROR         -1
#define JUST_CHECKING_OUTPUT_FILE -2
#define NO_OUTPUT_FILE            -3

#define output_fd_valid(fd)   ((fd) >= 0)

#if !OUTPUT_PAGER
# define output_pager_reset_more()             /* nothing */
# define output_pager_transparent(val)         (0)
# define output_pager_lines(val)               (0)
# define output_pager_columns(val)             (0)
# define output_pager_status(val)              (0)
#endif

#endif /* file wrapper */
