/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.lucene.analysis.lt;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.tests.analysis.BaseTokenStreamTestCase;

public class TestLithuanianAnalyzer extends BaseTokenStreamTestCase {

  /** This test fails with NPE when the stopwords file is missing in classpath */
  public void testResourcesAvailable() {
    new LithuanianAnalyzer().close();
  }

  /** Test stopword removal */
  public void testStopWord() throws Exception {
    Analyzer a = new LithuanianAnalyzer();
    assertAnalyzesTo(a, "man", new String[] {});
  }

  /** Test stemmer exceptions */
  public void testStemExclusion() throws IOException {
    CharArraySet set = new CharArraySet(1, true);
    set.add("vaikų");
    Analyzer a = new LithuanianAnalyzer(CharArraySet.EMPTY_SET, set);
    assertAnalyzesTo(a, "vaikų", new String[] {"vaikų"});
  }

  /** blast some random strings through the analyzer */
  public void testRandomStrings() throws Exception {
    checkRandomData(random(), new LithuanianAnalyzer(), 200 * RANDOM_MULTIPLIER);
  }
}
