message(STATUS "UNIX toolchain (non APPLE)")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)

set(LINKER_FLAGS "-Wl,--no-as-needed")

find_package(
    Qt6
    COMPONENTS Core
               Svg
               Xml
               Network
               PrintSupport
               Qml
               Sql
               Concurrent
               Core5Compat
    REQUIRED
)

find_package(IsoSpec++ REQUIRED)

find_package(PwizLite REQUIRED)

find_package(
    Boost
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)

find_package(QCustomPlotQt6 REQUIRED)

if(SQLite3_FOUND)
else(SQLite3_FOUND)
    set(SQLite3_DIR ${CMAKE_MODULE_PATH})
    find_package(SQLite3 REQUIRED)
endif(SQLite3_FOUND)

find_package(ZLIB REQUIRED)

find_package(Zstd REQUIRED)

find_package(liblzf REQUIRED)

find_package(OdsStream COMPONENTS Core)

find_package(QuaZip-Qt6 REQUIRED)

find_package(QScintilla REQUIRED)

if(PAPPSO_LOCAL_INST)
    message(STATUS "Selecting the .local pappso libs install setup.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-inst-pappso.cmake)
elseif(PAPPSO_LOCAL_DEV)
    message(STATUS "Selecting the local pappso lib development setup.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-dev-pappso.cmake)
else()
    find_package(
        PappsoMSpp
        COMPONENTS Core Gui GLOBAL
        REQUIRED
    )
endif()


#OPENMP
message(STATUS "${BoldYellow}OpenMP support is compulsory.${ColourReset}")
#message(STATUS "CMAKE_MODULE_PATH: ${CMAKE_MODULE_PATH}")
#set(OpenMP_DIR ${CMAKE_MODULE_PATH})

find_package(OpenMP REQUIRED)

#We know this one is empty:
#message(STATUS "OpenMP found with include dirs: ${OpenMP_CXX_INCLUDE_DIRS}")

#Which is why we will reconstruct it for gcc
#on the basis of the path to the libgomp.so library.The include
#directory is nothing more than the path to that library with '/include'
#added to it.This is what is done below.
message(STATUS "OpenMP found with libraries: ${OpenMP_CXX_LIBRARIES}")

# On mingw64 with ucrt64 environment, the include file is
# /c/msys64/ucrt64/lib/gcc/x86_64-w64-mingw32/13.2.0/include/omp.h

if(OpenMP_CXX_INCLUDE_DIRS STREQUAL "")

  message(STATUS "OpenMP include directories could not be found.
  Crafting them manually starting from the library directories.")

  if(CMAKE_COMPILER_IS_GNUCXX)

    message(STATUS "The compiler is CMAKE_COMPILER_IS_GNUCXX")

    #We now need to extract the libgomp.so library path, and craft the
    #include dir path which is replacing libgomp.so with include.
    set(OpenMP_CXX_INCLUDE_DIRS ${OpenMP_CXX_LIBRARIES})
    list(FILTER OpenMP_CXX_INCLUDE_DIRS INCLUDE REGEX ".*libgomp.*")
    #message(STATUS "Started crafting OpenMP include dirs: ${OpenMP_CXX_INCLUDE_DIRS}")
    list(LENGTH OpenMP_CXX_INCLUDE_DIRS INCLUDE_DIRS_LIST_LENGTH)
    #message(STATUS "Remaining items in OpenMP_CXX_INCLUDE_DIRS: ${INCLUDE_DIRS_LIST_LENGTH}")
    list(GET OpenMP_CXX_INCLUDE_DIRS 0 OpenMP_CXX_INCLUDE_DIR)
    #message(STATUS "Started crafting OpenMP include dir: ${OpenMP_CXX_INCLUDE_DIR}")
    string(REGEX REPLACE "libgomp.so.*" "include" OpenMP_CXX_INCLUDE_SINGLE_DIR ${OpenMP_CXX_INCLUDE_DIR})
    message(STATUS "OpenMP single include dir: ${OpenMP_CXX_INCLUDE_SINGLE_DIR}")

    if(EXISTS "${OpenMP_CXX_INCLUDE_SINGLE_DIR}")
      set(OpenMP_CXX_INCLUDE_DIRS ${OpenMP_CXX_INCLUDE_SINGLE_DIR})
      message(STATUS "OpenMP found with include dirs: ${OpenMP_CXX_INCLUDE_DIRS}")
    else()
      set(OpenMP_CXX_INCLUDE_DIRS "")
      message(STATUS "OpenMP found but not the include directories.")
    endif()

  else() # Compiler is not CMAKE_COMPILER_IS_GNUCXX

    # Check if the compiler is clang++

    #set(DEBUG_COMPILER "/usr/bin/clang")
    #string(REGEX MATCH ".*clang\\+\\+.*" CMAKE_CXX_COMPILER_IS_CLANG ${DEBUG_COMPILER})

    string(REGEX MATCH ".*clang\\+\\+.*" CMAKE_CXX_COMPILER_IS_CLANG ${CMAKE_CXX_COMPILER})
    #string(FIND ${CMAKE_CXX_COMPILER} "clang++" CMAKE_CXX_COMPILER_IS_CLANG)

    if(CMAKE_CXX_COMPILER_IS_CLANG STREQUAL "")

      message(STATUS "Failed to identify compiler different than g++ and clang++")

    else()

      message(STATUS "The compiler has been identified as clang++: ${CMAKE_CXX_COMPILER}")

      execute_process (
        COMMAND bash -c "clang --print-resource-dir"
        OUTPUT_STRIP_TRAILING_WHITESPACE
        OUTPUT_VARIABLE CLANG_RESOURCE_DIR
      )

      if(${CLANG_RESOURCE_DIR} STREQUAL "")

        message(STATUS "Failed to determine the Clang resource dir")

      else()

        #message(STATUS "Clang resource dir: \"${CLANG_RESOURCE_DIR}\"")
        set(CLANG_RESOURCE_DIR "${CLANG_RESOURCE_DIR}/include")
        #message(STATUS "Clang resource dir: ${CLANG_RESOURCE_DIR}")

        if(EXISTS "${CLANG_RESOURCE_DIR}")
          set(OpenMP_CXX_INCLUDE_DIRS ${CLANG_RESOURCE_DIR})
          message(STATUS "OpenMP found with include dirs: ${OpenMP_CXX_INCLUDE_DIRS}")
        else()
          set(OpenMP_CXX_INCLUDE_DIRS "")
          message(STATUS "OpenMP found but not the include directories.")
        endif()

      endif()

    endif()

  endif()

endif()


## INSTALL directories
set(PROJECT_INSTALL_BIN_DIR ${CMAKE_INSTALL_BINDIR})
message(STATUS "The install library default: ${CMAKE_INSTALL_LIBDIR}")

get_deb_triplet_string(DEB_TRIPLET_STRING)

if(NOT "${CMAKE_LIBRARY_ARCHITECTURE}" STREQUAL "${DEB_TRIPLET_STRING}")
    message(FATAL_ERROR "Odd situation where CMAKE_LIBRARY_ARCHITECTURE is not equal to DEB_TRIPLET_STRING")
endif()

if(DEB_TRIPLET_STRING)
    set(CMAKE_INSTALL_TRIPLET_LIBDIR ${CMAKE_INSTALL_LIBDIR}/${DEB_TRIPLET_STRING})
    set(CMAKE_INSTALL_FULL_TRIPLET_LIBDIR ${CMAKE_INSTALL_FULL_LIBDIR}/${DEB_TRIPLET_STRING})
endif()

message(STATUS "The install library is configured: ${CMAKE_INSTALL_LIBDIR}")
message(STATUS "The full install library is configured: ${CMAKE_INSTALL_FULL_LIBDIR}")

message(STATUS "The install triplet library is configured: ${CMAKE_INSTALL_TRIPLET_LIBDIR}")
message(STATUS "The full install triplet library is configured: ${CMAKE_INSTALL_FULL_TRIPLET_LIBDIR}")

set(PROJECT_INSTALL_LIB_DIR ${CMAKE_INSTALL_LIBDIR})

# This one is <prefix>/share
set(PROJECT_INSTALL_DATA_DIR ${CMAKE_INSTALL_PREFIX}/${CMAKE_INSTALL_DATADIR})
set(PROJECT_INSTALL_DOC_DIR ${PROJECT_INSTALL_DATA_DIR}/doc/${LOWCASE_PROJECT_NAME})

## Platform-dependent compiler flags:
include(CheckCXXCompilerFlag)

if (WITH_FPIC)
  add_definitions(-fPIC)
endif()

