/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.TwoPointLineObject;

public class LineObject
extends TwoPointLineObject {
    static Count N = new Count();

    public LineObject(Construction construction, PointObject pointObject, PointObject pointObject2) {
        super(construction, pointObject, pointObject2);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Line";
    }

    public void updateText() {
        this.setText(LineObject.text2(Zirkel.name("text.line"), this.P1.getName(), this.P2.getName()));
    }

    public void validate() {
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X1 = this.P1.getX();
        this.Y1 = this.P1.getY();
        this.X2 = this.P2.getX();
        this.Y2 = this.P2.getY();
        this.DX = this.X2 - this.X1;
        this.DY = this.Y2 - this.Y1;
        this.R = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
        if (this.R < 1.0E-10) {
            this.Valid = false;
            return;
        }
        this.DX /= this.R;
        this.DY /= this.R;
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        if (!this.Partial || zirkelCanvas.showHidden()) {
            super.paint(myGraphics, zirkelCanvas);
            return;
        }
        double d2 = (zirkelCanvas.minX() + zirkelCanvas.maxX()) / 2.0;
        double d3 = (zirkelCanvas.minY() + zirkelCanvas.maxY()) / 2.0;
        double d4 = (d2 - this.X1) * this.DY - (d3 - this.Y1) * this.DX;
        double d5 = d2 - d4 * this.DY;
        double d6 = d3 + d4 * this.DX;
        double d7 = Math.max(zirkelCanvas.maxX() - zirkelCanvas.minX(), zirkelCanvas.maxY() - zirkelCanvas.minY());
        if (Math.abs(d4) > d7) {
            return;
        }
        double d8 = (d5 - this.X1) * this.DX + (d6 - this.Y1) * this.DY;
        this.k1 = d8 - d7;
        this.k2 = d8 + d7;
        this.k12valid = true;
        double d9 = (zirkelCanvas.maxX() - zirkelCanvas.minX()) / 20.0;
        double d10 = -d9;
        double d11 = this.R + d9;
        if (this.Dep != null) {
            for (int i = 0; i < this.NDep; ++i) {
                if (!this.Dep[i].valid() || this.Dep[i].mustHide(zirkelCanvas)) continue;
                double d12 = this.project(this.Dep[i].getX(), this.Dep[i].getY());
                if (d12 - d9 < d10) {
                    d10 = d12 - d9;
                    continue;
                }
                if (!(d12 + d9 > d11)) continue;
                d11 = d12 + d9;
            }
        }
        if (this.k1 < d10) {
            this.k1 = d10;
        }
        if (this.k2 > d11) {
            this.k2 = d11;
        }
        double d13 = zirkelCanvas.col(this.X1 + this.k1 * this.DX);
        double d14 = zirkelCanvas.col(this.X1 + this.k2 * this.DX);
        double d15 = zirkelCanvas.row(this.Y1 + this.k1 * this.DY);
        double d16 = zirkelCanvas.row(this.Y1 + this.k2 * this.DY);
        if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
            ((MyGraphics13)myGraphics).drawMarkerLine(d13, d15, d14, d16);
        }
        myGraphics.setColor(this);
        myGraphics.drawLine(d13, d15, d14, d16, this);
        String string = this.getDisplayText();
        if (!string.equals("")) {
            myGraphics.setLabelColor(this);
            this.setFont(myGraphics);
            this.DisplaysText = true;
            if (this.KeepClose) {
                double d17 = this.YcOffset < 0.0 ? 1.0 : -1.0;
                this.drawLabel(myGraphics, string, zirkelCanvas, this.X1 + this.XcOffset * this.DX, this.Y1 + this.XcOffset * this.DY, d17 * this.DX, d17 * this.DY, 0.0, 0.0);
            } else {
                this.drawLabel(myGraphics, string, zirkelCanvas, this.X1 + this.k2 * this.DX / 2.0, this.Y1 + this.k2 * this.DY / 2.0, this.DX, this.DY, this.XcOffset, this.YcOffset);
            }
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("from", this.P1.getName());
        xmlWriter.printArg("to", this.P2.getName());
        super.printArgs(xmlWriter);
    }

    public void setDefaults() {
        super.setDefaults();
        this.setPartial(this.Cn.PartialLines);
    }

    public void toggleHidden() {
        if (this.Hidden) {
            this.Partial = false;
            this.Hidden = false;
        } else if (this.Partial) {
            this.Partial = false;
            this.Hidden = true;
        } else {
            this.Partial = true;
        }
    }

    public boolean hasUnit() {
        return false;
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        double d2;
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        if (zirkelCanvas.showHidden() || !this.Partial || this.Dep == null || !this.k12valid) {
            return super.nearto(n, n2, zirkelCanvas);
        }
        double d3 = zirkelCanvas.x(n);
        double d4 = this.project(d3, d2 = zirkelCanvas.y(n2));
        if (d4 < this.k1 || d4 > this.k2) {
            return false;
        }
        double d5 = (d3 - this.X1) * this.DY - (d2 - this.Y1) * this.DX;
        this.Value = Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d5) - zirkelCanvas.col(zirkelCanvas.minX()));
        return this.Value < zirkelCanvas.selectionSize() * 2.0;
    }
}

